#include "resultdata.h"

resultdata::resultdata()
{
	calculated = false;
}

resultdata::~resultdata()
{
	if (calculated == false) {
		return;
	}
	if (player_count > 0) {
		for (int i = 0; i < player_count; i++) {
			for (int j = 0; j < player_count; j++) {
				delete[] kills[i][j];
			}
			delete[] kills[i];
			delete[] player_total_kills[i];
			delete[] total_was_killed[i];
			delete[] deaths[i];
		}
		delete[] kills;
		delete[] player_total_kills;
		delete[] total_was_killed;
		delete[] deaths;
		delete[] flag_captures;
		delete[] ctf_assists;
		delete[] ctf_helped_return;
		delete[] flag_steals;
		delete[] flag_drops;
		delete[] flag_returns;
		delete[] ctf_defend_flag;
		delete[] ctf_defend_base;
		delete[] ctf_defend_flagcarrier;
		delete[] ctf_defend_aggressive;
		delete[] flagcarrier_frags;
		delete[] extra_frags;
		delete[] players;
	}
	delete[] total_kills;
	current_demo = first_demo->next;
	while (current_demo != 0) {
		demo_t* temp = current_demo->next;
		map_t* current_map = current_demo->maps->next;
		while (current_map != 0) {
			map_t* temp = current_map->next;
			delete[] current_map->name;
			delete[] current_map->file;
			delete[] current_map;
			current_map = temp;
		}
		delete[] current_demo->maps;
		delete[] current_demo->name;
		delete[] current_demo;
		current_demo = temp;
	}
	delete[] first_demo;
	if (demo_count > 0) {
		delete[] demos;
	}
}

int resultdata::add_player(char* player)
{
	if (frozen == true) {
		err->msg_and_exit ("Can't add more players, kills already counted!");
	}
	int len = strlen (player);
	if (config->gametype == gt_log) {
		while ((len > 0) && 
			((player[--len] == ' ') || (player[len] == '.') || 
			(player[len] == '\n') || (player[len] == '\r'))) {
			player[len] = 0;
		}
	}
	if (exist_player (player) == false) {
		printf ("\n    Adding player \"%s\"", player);
		last_player->next = new player_t[1];
		last_player = last_player->next;
		strcpy (last_player->name, player);
		last_player->next = 0;
		player_count++;
		return 0;
	} else {
		return 1;
	}
}

void resultdata::add_map(char *name, char *file)
{
	printf ("\n        Adding map \"%s\"", name);
	map_t* map = last_demo->maps;
	while (map->next != 0) {
		map = map->next;
	}
	map->next = new map_t[1];
	map = map->next;
	map->name = new char[strlen(name)+1];
	map->file = new char[strlen(file)+1];
	strcpy (map->name, name);
	strcpy (map->file, file);
	map->next = 0;
	last_demo->mapcount++;
	last_map = map;
}

void resultdata::add_demo(char *name, int size, int seconds)
{
	printf ("\n    Adding demo \"%s\"", name);
	last_demo->next = new demo_t[1];
	last_demo = last_demo->next;
	last_demo->name = new char[strlen(name)+1];
	strcpy (last_demo->name, name);
	last_demo->size = size;
	last_demo->seconds = seconds;
	last_demo->next = 0;
	last_demo->mapcount = 0;
	last_demo->maps = new map_t[1];
	last_demo->maps->next = 0;
	demo_count++;
}

bool resultdata::exist_player(char* player)
{
	player_t* temp = first_player;
	while (temp->next != 0) {
		temp = temp->next;
		if (stricmp (temp->name, player) == 0) {
			return true;
		}
	}
	return false;
}

void resultdata::freeze()
{
	printf ("\nParsing player data");
	parse_player_data();
	printf ("\nParsing demo data");
	parse_demo_data();
	printf ("\nBuilding data structures");
	init_data();
	if (config->no_claninfo == false) {
		printf ("\nGetting player clans");
		get_player_clans();
	}
	frozen = true;
}

void resultdata::init_data()
{
	printf ("\n    Alloc and init arrays ");
	kills = new int**[player_count];
	player_total_kills = new int*[player_count];
	total_was_killed = new int*[player_count];
	deaths = new int*[player_count];
	flag_captures = new int[player_count];
	ctf_assists = new int[player_count];
	ctf_helped_return = new int[player_count];
	flag_steals = new int[player_count];
	flag_drops = new int[player_count];
	flag_returns = new int[player_count];
	ctf_defend_flag = new int[player_count];
	ctf_defend_base = new int[player_count];
	ctf_defend_flagcarrier = new int[player_count];
	ctf_defend_aggressive = new int[player_count];
	flagcarrier_frags = new int[player_count];
	extra_frags = new int[player_count];
	for (int i = 0; i < player_count; i++) {
		// alloc
		kills[i] = new int*[player_count];
		player_total_kills[i] = new int[config->get_weapon_count()];
		total_was_killed[i] = new int[config->get_weapon_count()];
		deaths[i] = new int[config->get_deathtype_count()];
		// init
		extra_frags[i] = 0;
		flag_captures[i] = 0;
		ctf_assists[i] = 0;
		ctf_helped_return[i] = 0;
		flag_steals[i] = 0;
		flag_drops[i] = 0;
		flag_returns[i] = 0;
		ctf_defend_flag[i] = 0;
		ctf_defend_base[i] = 0;
		ctf_defend_flagcarrier[i] = 0;
		ctf_defend_aggressive[i] = 0;
		flagcarrier_frags[i] = 0;
		for (int j = 0; j < player_count; j++) {
			// alloc
			kills[i][j] = new int[config->get_weapon_count()];
			for (int k = 0; k < config->get_weapon_count(); k++) {
				// init
				kills[i][j][k] = 0;
			}
		}
		for (j = 0; j < config->get_weapon_count(); j++) { 
			// init
			player_total_kills[i][j] = 0;
			total_was_killed[i][j] = 0;
		}
		for (j = 0; j < config->get_deathtype_count(); j++) { 
			deaths[i][j] = 0;
		}
	}
	total_kills = new int[config->get_weapon_count()];
	for (i = 0; i < config->get_weapon_count(); i++) {
		total_kills[i] = 0;
	}
}

void resultdata::parse_player_data()
{
	players = new player_t[player_count];
	player_t* temp = first_player;
	int pnum = 0;
	while (temp->next != 0) {
		temp = temp->next;
		strcpy (players[pnum].name, temp->name);
		players[pnum].lifetime_shortest = -1;
		players[pnum].lifetime_longest = 0;
		players[pnum].team = -1;
		players[pnum].quad_time = 0;
		players[pnum].quad_kills = 0;
		pnum++;
	}
	player_t* current_player = first_player->next;
	while (current_player != 0) {
		temp = current_player->next;
		delete[] current_player;
		current_player = temp;
	}
	delete[] first_player;
}

void resultdata::parse_demo_data()
{
	demos = new demo_t*[demo_count];
	demo_t* current_demo = first_demo->next;
	for (int i = 0; i < demo_count; i++) {
		demos[i] = current_demo;
		current_demo = current_demo->next;
	}
}

void resultdata::get_player_clans()
{
	for (int j = 0; j < player_count; j++) {
		players[j].clan = -1;
		for (int i = 0; i < config->get_clan_count(); i++) {
			clan_id_t* clan_id = config->get_clan(i)->ids->next;
			while (clan_id != 0) {
				if (misc->find_sub(0, players[j].name, strlen(players[j].name),
					clan_id->id, strlen(clan_id->id)) >= 0) {
					players[j].clan = i;
				}
				clan_id = clan_id->next;
			}
		}
	}
}

void resultdata::add_kill(int killer, int victim, int weapon)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add kills yet! Data not frozen!");
	}
	if (weapon >= config->get_weapon_count()) {
		err->msg_and_exit ("Weapon %i doesn't exist!", weapon);
	}
	if ((killer > 0) && (victim > 0)) {
		kills[killer-1][victim-1][weapon]++;
		if (killer != victim) {
			player_total_kills[killer-1][weapon]++;
			total_was_killed[victim-1][weapon]++;
		}
		if (weapon != 0) {
			kills[killer-1][victim-1][0]++;
			if (killer != victim) {
				player_total_kills[killer-1][0]++;
				total_was_killed[victim-1][0]++;
			}
		}
	} 
}

void resultdata::add_death(int player, int deathtype)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add deaths yet!");
	}
	deaths[player-1][deathtype]++;
	if (deathtype != 0) {
		deaths[player-1][0]++;
	}		
}

void resultdata::add_extra_frags(int player, int amount)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	extra_frags[player-1] += amount;
}

void resultdata::add_flag_capture(int player, int team)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	flag_captures[player-1]++;
}

void resultdata::add_ctf_assist(int player, int team)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	ctf_assists[player-1]++;
}

void resultdata::add_ctf_helped_return(int player, int team)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	ctf_helped_return[player-1]++;
}

void resultdata::add_flag_steal(int player, int team)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	flag_steals[player-1]++;
}

void resultdata::add_flag_loss(int player, int team)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	flag_drops[player-1]++;
}

void resultdata::add_flag_return(int player, int team)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	flag_returns[player-1]++;
}

void resultdata::add_ctf_defend_flag(int player, int team)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	ctf_defend_flag[player-1]++;
}

void resultdata::add_ctf_defend_base(int player, int team)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	ctf_defend_base[player-1]++;
}

void resultdata::add_ctf_defend_flagcarrier(int player, int team)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	ctf_defend_flagcarrier[player-1]++;
}

void resultdata::add_ctf_defend_aggressive(int player, int team)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	ctf_defend_aggressive[player-1]++;
}

void resultdata::add_flagcarrier_frag(int player, int team)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't add extra_frags yet!");
	}
	flagcarrier_frags[player-1]++;
}

player_t* resultdata::get_player(int num)
{
	return &players[num-1];
}

int resultdata::get_player_count ()
{
	return player_count;
}

int resultdata::get_player_kills (int killer, int victim, int weapon)
{
	return kills[killer-1][victim-1][weapon];
}

int resultdata::get_player_suicides (int player, int weapon)
{
	return kills[player-1][player-1][weapon];
}

int resultdata::get_player_deaths (int player, int deathtype)
{
	return deaths[player-1][deathtype];
}

int resultdata::get_player_extra_frags (int player)
{
	return extra_frags[player-1];
}

int resultdata::get_player_flag_captures(int player)
{
	return flag_captures[player-1];
}

int resultdata::get_player_ctf_assists(int player)
{
	return ctf_assists[player-1];
}

int resultdata::get_player_ctf_helped_return(int player)
{
	return ctf_helped_return[player-1];
}

int resultdata::get_player_flag_steals(int player)
{
	return flag_steals[player-1];
}

int resultdata::get_player_flag_drops(int player)
{
	return flag_drops[player-1];
}

int resultdata::get_player_flag_returns(int player)
{
	return flag_returns[player-1];
}

int resultdata::get_player_ctf_defend_flag(int player)
{
	return ctf_defend_flag[player-1];
}

int resultdata::get_player_ctf_defend_base(int player)
{
	return ctf_defend_base[player-1];
}

int resultdata::get_player_ctf_defend_flagcarrier(int player)
{
	return ctf_defend_flagcarrier[player-1];
}

int resultdata::get_player_ctf_defend_aggressive(int player)
{
	return ctf_defend_aggressive[player-1];
}

int resultdata::get_player_flagcarrier_frags(int player)
{
	return flagcarrier_frags[player-1];
}

int resultdata::get_player_mkiol (int player)
{
	return players[player-1].mkiol;
}

int resultdata::get_player_lifetime_total (int player)
{
	return players[player-1].lifetime_total;
}

int resultdata::get_player_lifetime_average (int player)
{
	return players[player-1].lifetime_average;
}

int resultdata::get_player_lifetime_longest (int player)
{
	return players[player-1].lifetime_longest;
}

int resultdata::get_player_lifetime_shortest (int player)
{
	if (players[player-1].lifetime_shortest == -1) {
		return 0;
	} else {
		return players[player-1].lifetime_shortest;
	}
}

int resultdata::get_total_time ()
{
	return total_time;
}

int resultdata::get_player_frags (int player)
{
	int count = 0;
	count = get_player_total_kills(player,0) 
		+ get_player_extra_frags(player)
		- get_player_deaths(player,0)
		- get_player_suicides(player,0);
	return count;
}

int resultdata::get_player_total_kills (int pnum, int weapon)
{
	return (player_total_kills[pnum-1][weapon] - get_player_memberkills(pnum, weapon));
}

int resultdata::get_player_total_waskilled (int pnum, int weapon)
{
	return (total_was_killed[pnum-1][weapon] - get_player_memberkilled(pnum,weapon));
}

int resultdata::get_total_kills (int weapon)
{
	if (total_kills[weapon] == 0) {
		for (int i = 1; i <= get_player_count(); i++) {
			total_kills[weapon] += get_player_total_kills(i,weapon);
		}
	}
	return total_kills[weapon];
}

int resultdata::get_total_deaths (int deathtype)
{
	int deaths_temp = 0;
	for (int i = 1; i <= get_player_count(); i++) {
		deaths_temp += get_player_deaths(i,deathtype);
	}
	return deaths_temp;
}


int resultdata::get_player_number(char * name)
{
	if (name[0] == 0) {
		return -1;
	}
	for (int i = 0; i < player_count; i++) {
		if (stricmp (name, players[i].name) == 0) {
			return ++i;
		}
	}
	return -1;
}

void resultdata::set_player_mkiol(int player, int count)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't set player_mkiol info yet!");
	}
	players[player-1].mkiol = count;
}

void resultdata::set_player_lifetime_total(int player, int lifetime)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't set player_lifetime info yet!");
	}
	if (player < 0) {
		return;
	}
	players[player-1].lifetime_total = lifetime;	
}

void resultdata::set_player_lifetime_average(int player, int lifetime)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't set player_lifetime info yet!");
	}
	if (player < 0) {
		return;
	}
	players[player-1].lifetime_average = lifetime;	
}

void resultdata::set_player_lifetime_longest(int player, int lifetime)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't set player_lifetime info yet!");
	}
	if (player < 0) {
		return;
	}
	if (lifetime > players[player-1].lifetime_longest) {
		players[player-1].lifetime_longest = lifetime;	
	}
}

void resultdata::set_player_lifetime_shortest(int player, int lifetime)
{
	if (frozen == false) {
		err->msg_and_exit ("Can't set player_lifetime info yet!");
	}
	if (player < 0) {
		return;
	}
	if ((lifetime < players[player-1].lifetime_shortest) ||
		(players[player-1].lifetime_shortest == -1)) {
		players[player-1].lifetime_shortest = lifetime;	
	}
}

void resultdata::set_total_time(int time)
{
	total_time = time;
}

float resultdata::get_player_ratio (int pnum)
{
	double ratio = (get_player_kph(pnum) - get_player_dph(pnum)); 
	if ((ratio < 0) && (ratio > -0.005)) {
		ratio = 0;
	}
	return ratio;
}

float resultdata::get_player_skill (int pnum)
{
	double skill = ((double) get_player_total_kills(pnum,0) 
		/ (double) ((double) get_player_total_waskilled(pnum,0) 
		+ (double) get_player_suicides(pnum,0) 
		+ (double) get_player_deaths(pnum,0)
		+ 1.0));
	return skill;
}

float resultdata::get_player_fph (int pnum)
{
	float fph;
	if (get_player(pnum)->lifetime_total > 0) {
		fph = (float) (get_player_frags(pnum)) 
			/ (float) (get_player(pnum)->lifetime_total) * 36000;
	} else {
		fph = 0.0;
	}
	return fph;
}

float resultdata::get_player_kph(int pnum)
{
	float kph;
	if (get_player(pnum)->lifetime_total > 0) {
		kph = (float) (get_player_total_kills(pnum,0)) 
			/ (float) (get_player(pnum)->lifetime_total) * 36000;
	} else {
		kph = 0.0;
	}
	return kph;
}

float resultdata::get_player_dph (int pnum)
{
	float dph;
	if (get_player(pnum)->lifetime_total > 0) {
		dph = (float) (get_player_total_waskilled(pnum,0) 
			+ get_player_kills (pnum, pnum, 0)
			+ get_player_deaths(pnum,0)) 
			/ (float) (get_player(pnum)->lifetime_total) * 36000;
	} else {
		dph = 0.0;
	}
	return dph;
}

int resultdata::get_player_worst_enemy (int pnum) 
{
	int enemy = -1;
	int kills_temp = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_kills(i, pnum, 0) > kills_temp) {
			enemy = i;
			kills_temp = get_player_kills(i, pnum, 0);
		}
	}
	return enemy;
}

int resultdata::get_player_easiest_prey (int pnum) 
{
	int enemy = -1;
	int kills_temp = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_kills(pnum, i, 0) > kills_temp) {
			enemy = i;
			kills_temp = get_player_kills(pnum, i, 0);
		}
	}
	return enemy;
}

int resultdata::get_player_favourite_weapon (short pnum) 
{
	int max = 0;
	int fav = -1;
	for (int weapon = 1; weapon < config->get_weapon_count(); weapon++) {
		int kills_temp = get_player_total_kills (pnum, weapon);
		if (kills_temp > max) {
			max = kills_temp;
			fav = weapon;
		}
	}
	return fav;
}

void resultdata::sort_players(sort_t order)
{
	char str1[256];
	char str2[256];
	bool sort;
	int i, j;
	int min;
	for (i = 1; i < player_count; i++) {
		sort = false;
		switch (order) {
		case so_name: // name
			min = i;
			for (j = min+1; j <= player_count; j++) {
				strcpy (str1, players[min-1].name);
				strcpy (str2, players[j-1].name);
				if (strcmp (_strupr (str1), _strupr (str2)) > 0) {
					min = j;
				}
			}
			break;
		case so_clan: // clan
			min = i;
			for (j = min+1; j <= player_count; j++) {
				if (get_player(min)->clan < get_player(j)->clan) {
					min = j;
				}
			}
			break;
		case so_team: // team
			min = i;
			for (j = min+1; j <= player_count; j++) {
				if (get_player(min)->team > get_player(j)->team) {
					min = j;
				}
			}
			break;
		case so_frags: // frags
			min = i;
			for (j = min+1; j <= player_count; j++) {
				if (get_player_frags(min) < get_player_frags(j)) {
					min = j;
				}
			}
			break;
		case so_kills: // kills
			min = i;
			for (j = min+1; j <= player_count; j++) {
				if (get_player_total_kills(min,0) < get_player_total_kills(j,0)) {
					min = j;
				}
			}
			break;
		case so_skill: // skill
			min = i;
			for (j = min+1; j <= player_count; j++) {
				if (get_player_skill(min) <  get_player_skill(j)) {
					min = j;
				}
			}
			break;
		case so_ratio: // ratio
			min = i;
			for (j = min+1; j <= player_count; j++) {
				if (get_player_ratio(min) <  get_player_ratio(j)) {
					min = j;
				}
			}
			break;
		case so_fph: // fph
			min = i;
			for (j = min+1; j <= player_count; j++) {
				if (get_player_fph(min) <  get_player_fph(j)) {
					min = j;
				}
			}
			break;
		case so_kph: // kph
			min = i;
			for (j = min+1; j <= player_count; j++) {
				if (get_player_kph(min) <  get_player_kph(j)) {
					min = j;
				}
			}
			break;
		case so_ctf_score: // ctf total score
			min = i;
			for (j = min+1; j <= player_count; j++) {
				if (get_player_ctf_score(min)+get_player_frags(min) 
					< get_player_ctf_score(j)+get_player_frags(j)) {
					min = j;
				}
			}
			break;
		default:
			err->msg_and_exit ("This sort order is not yet implemented!");
			return;
		}
		if (i != min) {
			swap_players (i-1, min-1);
		}
	}
}

void resultdata::swap_players(int player1, int player2)
{
	player_t pPlayer = players[player1];
	players[player1] = players[player2];
	players[player2] = pPlayer;
	int temp1 = extra_frags[player1]; // extra frags
	extra_frags[player1] = extra_frags[player2]; 
	extra_frags[player2] = temp1;
	temp1 = flag_captures[player1]; // flag captures
	flag_captures[player1] = flag_captures[player2]; 
	flag_captures[player2] = temp1;
	temp1 = ctf_assists[player1]; // ctf assists
	ctf_assists[player1] = ctf_assists[player2]; 
	ctf_assists[player2] = temp1;
	temp1 = ctf_helped_return[player1]; // ctf assists
	ctf_helped_return[player1] = ctf_helped_return[player2]; 
	ctf_helped_return[player2] = temp1;
	temp1 = flag_steals[player1]; // flag steals
	flag_steals[player1] = flag_steals[player2]; 
	flag_steals[player2] = temp1;
	temp1 = flag_drops[player1]; // flag drops
	flag_drops[player1] = flag_drops[player2]; 
	flag_drops[player2] = temp1;
	temp1 = ctf_defend_flag[player1]; // flag defends
	ctf_defend_flag[player1] = ctf_defend_flag[player2]; 
	ctf_defend_flag[player2] = temp1;
	temp1 = ctf_defend_base[player1]; // base defends
	ctf_defend_base[player1] = ctf_defend_base[player2]; 
	ctf_defend_base[player2] = temp1;
	temp1 = ctf_defend_flagcarrier[player1]; // flagcarrier defends
	ctf_defend_flagcarrier[player1] = ctf_defend_flagcarrier[player2]; 
	ctf_defend_flagcarrier[player2] = temp1;
	temp1 = ctf_defend_aggressive[player1]; // aggressive flagcarrier defends
	ctf_defend_aggressive[player1] = ctf_defend_aggressive[player2]; 
	ctf_defend_aggressive[player2] = temp1;
	temp1 = flag_returns[player1]; // flag returns
	flag_returns[player1] = flag_returns[player2]; 
	flag_returns[player2] = temp1;
	temp1 = flagcarrier_frags[player1]; // flagcarrier frags
	flagcarrier_frags[player1] = flagcarrier_frags[player2]; 
	flagcarrier_frags[player2] = temp1;
    int* temp = deaths[player1]; // deaths
	deaths[player1] = deaths[player2];
	deaths[player2] = temp;
	temp = player_total_kills[player1]; // player_total_kills
	player_total_kills[player1] = player_total_kills[player2];
	player_total_kills[player2] = temp;
	temp = total_was_killed[player1]; // total_was_killed
	total_was_killed[player1] = total_was_killed[player2];
	total_was_killed[player2] = temp;
	for (int i = 0; i < player_count; i++) {
		// vertical swap
		temp = kills[i][player1];
		kills[i][player1] = kills[i][player2];
		kills[i][player2] = temp;
	}
	// horizontal swap
	int** temp2 = kills[player1];
	kills[player1] = kills[player2];
	kills[player2] = temp2;
}

void resultdata::delete_nullplayers()
{
	for (int i = 1; i <= player_count; i++) {
		if ((get_player_total_kills(i,0) != 0) 
			|| (get_player_deaths(i,0) != 0)
			|| (get_player_suicides(i,0) != 0)
			|| (get_player_total_waskilled(i,0) != 0)) {
			continue;
		}
		for (int j = i-1; j < player_count-1; j++) {
			players[j] = players[j+1];
			extra_frags[j] = extra_frags[j+1];
			deaths[j] = deaths[j+1];
			player_total_kills[j] = player_total_kills[j+1];
			total_was_killed[j] = total_was_killed[j+1];
			flag_captures[j] = flag_captures[j+1];
			ctf_assists[j] = ctf_assists[j+1];
			ctf_helped_return[j] = ctf_helped_return[j+1];
			flag_steals[j] = flag_steals[j+1];
			flag_drops[j] = flag_drops[j+1];
			ctf_defend_flag[j] = ctf_defend_flag[j+1];
			ctf_defend_base[j] = ctf_defend_base[j+1];
			ctf_defend_flagcarrier[j] = ctf_defend_flagcarrier[j+1];
			ctf_defend_aggressive[j] = ctf_defend_aggressive[j+1];
			flag_returns[j] = flag_returns[j+1];
			flagcarrier_frags[j] = flagcarrier_frags[j+1];
			for (int l = 0; l < player_count; l++) {
				kills[l][j] = kills[l][j+1];
			}
			kills[j] = kills[j+1];
		}
		i--;
		player_count--;
	}
}

void resultdata::set_demo_count(int count)
{
	demo_count = count;
}

int resultdata::get_demo_count()
{
	return demo_count;
}

int resultdata::get_clan_frags(int clan)
{
	int clan_frags = 0;
	for (int j = 0; j < player_count; j++) {
		if (players[j].clan == clan) {
			clan_frags += get_player_frags(j+1);
		}
	}
	return clan_frags;
}

int resultdata::get_clan_kills(int clan)
{
	int clan_kills = 0;
	for (int j = 0; j < player_count; j++) {
		if (players[j].clan == clan) {
			clan_kills += get_player_total_kills(j+1, 0);
		}
	}
	return clan_kills;
}

int resultdata::get_clan_suicides(int clan)
{
	int clan_suicides = 0;
	for (int j = 0; j < player_count; j++) {
		if (players[j].clan == clan) {
			clan_suicides += get_player_suicides(j+1, 0);
		}
	}
	return clan_suicides;
}

int resultdata::get_clan_deaths(int clan)
{
	int clan_deaths = 0;
	for (int j = 0; j < player_count; j++) {
		if (players[j].clan == clan) {
			clan_deaths += get_player_deaths(j+1, 0);
		}
	}
	return clan_deaths;
}

int resultdata::get_clan_memberkills(int clan)
{
	int clan_memberkills = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].clan != clan) {
			continue;
		}
		for (int j = 0; j < player_count; j++) {
			if ((i != j) && (players[j].clan == clan)) {
				clan_memberkills += get_player_kills(i+1,j+1,0);
			}
		}
	}
	return clan_memberkills;
}

void resultdata::set_player_team(int player, int team)
{
	if ((team == 0) || (team == 1)) {
		players[player-1].team = team;
	}
}

int resultdata::get_team_flag_captures(int team)
{
	int team_flag_captures = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_flag_captures += flag_captures[i];
		}
	}
	return team_flag_captures;
}

int resultdata::get_team_ctf_assists(int team)
{
	int team_ctf_assists = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_ctf_assists += ctf_assists[i];
		}
	}
	return team_ctf_assists;
}

int resultdata::get_team_ctf_helped_return(int team)
{
	int team_ctf_helped_return = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_ctf_helped_return += ctf_helped_return[i];
		}
	}
	return team_ctf_helped_return;
}

int resultdata::get_team_flag_drops(int team)
{
	int team_flag_drops = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_flag_drops += flag_drops[i];
		}
	}
	return team_flag_drops;
}

int resultdata::get_team_flag_steals(int team)
{
	int team_flag_steals = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_flag_steals += flag_steals[i];
		}
	}
	return team_flag_steals;
}

int resultdata::get_team_ctf_defend_flag(int team)
{
	int team_ctf_defend_flag = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_ctf_defend_flag += ctf_defend_flag[i];
		}
	}
	return team_ctf_defend_flag;
}

int resultdata::get_team_ctf_defend_base(int team)
{
	int team_ctf_defend_base = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_ctf_defend_base += ctf_defend_base[i];
		}
	}
	return team_ctf_defend_base;
}

int resultdata::get_team_ctf_defend_flagcarrier(int team)
{
	int team_ctf_defend_flagcarrier = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_ctf_defend_flagcarrier += ctf_defend_flagcarrier[i];
		}
	}
	return team_ctf_defend_flagcarrier;
}

int resultdata::get_team_ctf_defend_aggressive(int team)
{
	int team_ctf_defend_aggressive = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_ctf_defend_aggressive += ctf_defend_aggressive[i];
		}
	}
	return team_ctf_defend_aggressive;
}

int resultdata::get_team_flag_returns(int team)
{
	int team_flag_returns = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_flag_returns += flag_returns[i];
		}
	}
	return team_flag_returns;
}

int resultdata::get_team_flagcarrier_frags(int team)
{
	int team_flagcarrier_frags = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_flagcarrier_frags += flagcarrier_frags[i];
		}
	}
	return team_flagcarrier_frags;
}

int resultdata::get_favourite_weapon()
{
	int max = 0;
	int fav = -1;
	for (int weapon = 1; weapon < config->get_weapon_count(); weapon++) {
		int kills_temp = get_total_kills (weapon);
		if (kills_temp > max) {
			max = kills_temp;
			fav = weapon;
		}
	}
	return fav;
}

int resultdata::get_team_frags(int team)
{
	int team_frags = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_frags += get_player_frags(i+1);
		}
	}
	return team_frags;
}

int resultdata::get_team_kills(int team)
{
	int team_kills = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_kills += get_player_total_kills(i+1,0);
		}
	}
	return team_kills;
}

int resultdata::get_team_killed(int team)
{
	int team_killed = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_killed += get_player_total_waskilled(i+1,0);
		}
	}
	return team_killed;
}

int resultdata::get_team_suicides(int team)
{
	int team_suicides = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_suicides += get_player_suicides(i+1,0);
		}
	}
	return team_suicides;
}

int resultdata::get_team_deaths(int team)
{
	int team_deaths = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_deaths += get_player_deaths(i+1,0);
		}
	}
	return team_deaths;
}

int resultdata::get_team_total_deaths(int team)
{
	return (get_team_killed(team) + get_team_suicides(team) + get_team_deaths(team));
}

int resultdata::get_team_member_count(int team)
{
	int count = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			count++;
		}
	}
	return count;
}

int resultdata::get_team_quadtime(int team)
{
	int team_quadtime = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_quadtime += get_player(i+1)->quad_time;
		}
	}
	return team_quadtime;
}

int resultdata::get_team_quadkills(int team)
{
	int team_quadkills = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team == team) {
			team_quadkills += get_player(i+1)->quad_kills;
		}
	}
	return team_quadkills;
}

int resultdata::get_team_ctf_score(int team)
{
	int score = 0;
	score += get_team_flag_captures(team) * (get_team_member_count(team) * 10 + 5);
	score += get_team_flagcarrier_frags(team) * 2;
	score += get_team_ctf_defends_score(team);
	score += get_team_ctf_assists(team);
	score += get_team_ctf_helped_return(team); // only LMCTF v5?
	score += get_team_flag_returns(team);
	return score;
}

void resultdata::set_player_count(int count)
{
	player_count = count;
}

int resultdata::get_team_ctf_defends(int team)
{
	int defends = 0;
	defends += get_team_ctf_defend_flag(team);
	defends += get_team_ctf_defend_base(team);
	defends += get_team_ctf_defend_flagcarrier(team);
	defends += get_team_ctf_defend_aggressive(team);
	return defends;
}

int resultdata::get_team_ctf_defends_score(int team)
{
	int defends = 0;
	defends += get_team_ctf_defend_flag(team) * 2;
	defends += get_team_ctf_defend_base(team);
	defends += get_team_ctf_defend_flagcarrier(team) * 2;
	defends += get_team_ctf_defend_aggressive(team) * 3;
	return defends;
}

int resultdata::get_player_ctf_defends(int player)
{
	int defends = 0;
	defends += get_player_ctf_defend_flag(player);
	defends += get_player_ctf_defend_base(player);
	defends += get_player_ctf_defend_flagcarrier(player);
	defends += get_player_ctf_defend_aggressive(player);
	return defends;
}

int resultdata::get_player_ctf_defends_score(int player)
{
	int defends = 0;
	defends += get_player_ctf_defend_flag(player) * 2;
	defends += get_player_ctf_defend_base(player);
	defends += get_player_ctf_defend_flagcarrier(player) * 2;
	defends += get_player_ctf_defend_aggressive(player) * 3;
	return defends;
}

int resultdata::get_player_ctf_score(int player)
{
	int score = 0;
	score += get_player_flag_captures_score(player);
	score += get_player_flagcarrier_frags(player) * 2;
	score += get_player_ctf_defends_score(player);
	score += get_player_ctf_assists(player);
	score += get_player_ctf_helped_return(player); // only LMCTF v5?
	score += get_player_flag_returns(player);
	return score;
}

int resultdata::get_player_flag_captures_score(int player)
{
	int score = 0;
	score += get_team_flag_captures(players[player-1].team) * 10;
	score += get_player_flag_captures(player) * 5;
	return score;
}

demo_t* resultdata::get_demo(int num)
{
	return (demos[num]);
}


int resultdata::get_max_player_frags ()
{
	int maxcount = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_frags(i) > maxcount) {
			maxcount = get_player_frags(i);
		}
	}
	return maxcount;
}

int resultdata::get_max_player_total_kills ()
{
	int maxcount = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_total_kills(i,0) > maxcount) {
			maxcount = get_player_total_kills(i,0);
		}
	}
	return maxcount;
}

int resultdata::get_max_player_total_waskilled ()
{
	int maxcount = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_total_waskilled(i,0) > maxcount) {
			maxcount = get_player_total_waskilled(i,0);
		}
	}
	return maxcount;
}


int resultdata::get_max_player_suicides()
{
	int maxcount = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_suicides(i,0) > maxcount) {
			maxcount = get_player_suicides(i,0);
		}
	}
	return maxcount;
}

int resultdata::get_max_player_deaths(int type)
{
	int maxcount = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_deaths(i,type) > maxcount) {
			maxcount = get_player_deaths(i,type);
		}
	}
	return maxcount;
}

double resultdata::get_max_player_fph()
{
	double maxcount = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_fph(i) > maxcount) {
			maxcount = get_player_fph(i);
		}
	}
	return maxcount;
}

double resultdata::get_max_player_kph()
{
	double maxcount = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_kph(i) > maxcount) {
			maxcount = get_player_kph(i);
		}
	}
	return maxcount;
}

double resultdata::get_max_player_dph()
{
	double maxcount = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_dph(i) > maxcount) {
			maxcount = get_player_dph(i);
		}
	}
	return maxcount;
}

int resultdata::get_max_player_lifetime_average()
{
	int maxcount = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_lifetime_average(i) > maxcount) {
			maxcount = get_player_lifetime_average(i);
		}
	}
	return maxcount;
}

int resultdata::get_max_player_lifetime_longest()
{
	int maxcount = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_lifetime_longest(i) > maxcount) {
			maxcount = get_player_lifetime_longest(i);
		}
	}
	return maxcount;
}

int resultdata::get_max_player_mkiol()
{
	int maxcount = 0;
	for (int i = 1; i <= player_count; i++) {
		if (get_player_mkiol(i) > maxcount) {
			maxcount = get_player_mkiol(i);
		}
	}
	return maxcount;
}

void resultdata::calculate(configdata *in_config)
{
	config = in_config;
	frozen = false;
	first_player = new player_t[1];
	first_player->next = 0;
	last_player = first_player;
	current_player = first_player;
	first_demo = new demo_t[1];
	first_demo->next = 0;
	last_demo = first_demo;
	current_demo = first_demo;
	player_count = 0;
	demo_count = 0;
	last_map = 0;
	calculated = true;
}

int resultdata::get_player_rank (int pnum, sort_t order)
{
	int rank = 1;
	double p1 = 0;
	double p2 = 0;
	switch (order) {
	case so_frags:
		p1 = (int) get_player_frags (pnum);
		break;
	case so_skill:
		p1 = get_player_skill (pnum);
		break;
	case so_ratio:
		p1 = get_player_ratio (pnum);
		break;
	case so_kills:
		p1 = get_player_total_kills (pnum, 0);
		break;
	case so_memberkills:
		p1 = get_player_memberkills (pnum, 0);
		break;
	case so_quadtime:
		p1 = get_player(pnum)->quad_time;
		break;
	case so_quadkills:
		p1 = get_player(pnum)->quad_kills;
		break;
	case so_waskilled:
		p1 = get_player_total_waskilled (pnum, 0);
		break;
	case so_suicides:
		p1 = get_player_suicides (pnum, 0);
		break;
	case so_deaths:
		p1 = get_player_deaths (pnum, 0);
		break;
	case so_total_deaths:
		p1 = get_player_total_deaths (pnum);
		break;
	case so_fph:
		p1 = get_player_fph (pnum);
		break;
	case so_kph:
		p1 = get_player_kph (pnum);
		break;
	case so_dph:
		p1 = get_player_dph (pnum);
		break;
	case so_lifetime_average:
		p1 = get_player_lifetime_average (pnum);
		break;
	case so_lifetime_longest:
		p1 = get_player_lifetime_longest (pnum);
		break;
	case so_mkiol:
		p1 = get_player_mkiol (pnum);
		break;
	default:
		break;
	}
	for (int i = 1; i <= player_count; i++) {
		switch (order) {
		case so_frags:
			p2 = (int) get_player_frags (i);
			break;
		case so_skill:
			p2 = get_player_skill (i);
			break;
		case so_ratio:
			p2 = get_player_ratio (i);
			break;
		case so_kills:
			p2 = get_player_total_kills (i, 0);
			break;
		case so_memberkills:
			p2 = get_player_memberkills (i, 0);
			break;
		case so_quadtime:
			p2 = get_player(i)->quad_time;
			break;
		case so_quadkills:
			p2 = get_player(i)->quad_kills;
			break;
		case so_waskilled:
			p2 = get_player_total_waskilled (i, 0);
			break;
		case so_suicides:
			p2 = get_player_suicides (i, 0);
			break;
		case so_deaths:
			p2 = get_player_deaths (i, 0);
			break;
		case so_total_deaths:
			p2 = get_player_total_deaths (i);
			break;
		case so_fph:
			p2 = get_player_fph (i);
			break;
		case so_kph:
			p2 = get_player_kph (i);
			break;
		case so_dph:
			p2 = get_player_dph (i);
			break;
		case so_lifetime_average:
			p2 = get_player_lifetime_average (i);
			break;
		case so_lifetime_longest:
			p2 = get_player_lifetime_longest (i);
			break;
		case so_mkiol:
			p2 = get_player_mkiol (i);
			break;
		default:
			break;
		}
		switch (order) {
		case so_ratio:
		case so_skill:
		case so_frags:
		case so_kills:
		case so_quadtime:
		case so_quadkills:
		case so_fph:
		case so_kph:
		case so_lifetime_average:
		case so_lifetime_longest:
		case so_mkiol:
			if (p2 > p1) {
				rank++;
			}
			break;
		case so_waskilled:
		case so_memberkills:
		case so_suicides:
		case so_deaths:
		case so_total_deaths:
		case so_dph:
			if (p1 > p2) {
				rank++;
			}
			break;
		default:
			break;
		}
	}
	return rank;
}


int resultdata::get_quad_total_kills()
{
	int count = 0;
	for (int i = 1; i <= get_player_count(); i++) {
		count += get_player(i)->quad_kills;
	}
	return count;
}

int resultdata::get_team_memberkills(int team)
{
	if (team > 1) {
		err->msg_and_exit ("result::get_team_memberkills: team doesn't exist!");
	}
	int team_memberkills = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].team != team) {
			continue;
		}
		team_memberkills += get_player_memberkills(i+1, 0);
	}
	return team_memberkills;
}

int resultdata::get_player_total_deaths(int pnum)
{
	return (get_player_deaths(pnum,0) + get_player_suicides(pnum,0) 
		+ get_player_total_waskilled(pnum, 0));
}

int resultdata::get_player_memberkills(int pnum, int weapon)
{
	if (config->is_battle == false) { // battle only!
		return 0;
	}
	int member_kills = 0;
	for (int i = 1; i <= get_player_count(); i++) {
		if ((get_player(pnum)->team == get_player(i)->team) && (pnum != i)) {
			member_kills += get_player_kills (pnum, i, weapon);
		}
	}
	return member_kills;
}

int resultdata::get_player_memberkilled(int pnum, int weapon)
{
	if (config->is_battle == false) { // battle only!
		return 0;
	}
	int member_killed = 0;
	for (int i = 1; i <= get_player_count(); i++) {
		if ((get_player(pnum)->team == get_player(i)->team) && (pnum != i)) {
			member_killed += get_player_kills (i, pnum, weapon);
		}
	}
	return member_killed;
}
